/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Collections;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.data.role.ITransportLocation;
import noppes.npcs.controllers.data.TransportCategory;

public class TransportLocation
implements ITransportLocation {
    public TransportCategory category;
    public int dimension = 0;
    public int id = -1;
    public int type = 0;
    public long money = 0L;
    public String name = "aitactics.default";
    public BlockPos pos;
    public UUID npc = null;
    public final NpcMiscInventory inventory = new NpcMiscInventory(9);
    public float yaw = 0.0f;
    public float pitch = 0.0f;

    public TransportLocation copy() {
        TransportLocation tl = new TransportLocation();
        tl.id = this.id;
        tl.name = this.name;
        tl.type = this.type;
        tl.dimension = this.dimension;
        tl.npc = this.npc;
        tl.money = this.money;
        tl.pos = this.pos;
        for (int i = 0; i < this.inventory.items.size(); ++i) {
            tl.inventory.items.set(i, (Object)((ItemStack)this.inventory.items.get(i)).func_77946_l());
        }
        tl.category = this.category;
        tl.yaw = this.yaw;
        tl.pitch = this.yaw;
        return tl;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getX() {
        return this.pos.func_177958_n();
    }

    @Override
    public int getY() {
        return this.pos.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.pos.func_177952_p();
    }

    public boolean isDefault() {
        return this.type == 1;
    }

    public void readNBT(NBTTagCompound compound) {
        if (compound == null) {
            return;
        }
        this.id = compound.func_74762_e("Id");
        this.pos = new BlockPos(compound.func_74769_h("PosX"), compound.func_74769_h("PosY"), compound.func_74769_h("PosZ"));
        this.type = compound.func_74762_e("Type");
        this.dimension = compound.func_74762_e("Dimension");
        this.name = compound.func_74779_i("Name");
        this.npc = null;
        this.yaw = compound.func_74760_g("PlayerYaw");
        this.pitch = compound.func_74760_g("PlayerPitch");
        if (compound.func_150297_b("NpcUUIDMost", 4) && compound.func_150297_b("NpcUUIDLeast", 4)) {
            this.npc = compound.func_186857_a("NpcUUID");
        }
        this.money = compound.func_74763_f("Cost");
        if (compound.func_150297_b("CostInv", 10)) {
            this.inventory.load(compound.func_74775_l("CostInv"));
            while (this.inventory.items.size() < 9) {
                this.inventory.items.add((Object)ItemStack.field_190927_a);
            }
            while (this.inventory.items.size() > 9) {
                this.inventory.items.remove(this.inventory.items.size() - 1);
            }
        } else {
            Collections.fill(this.inventory.items, ItemStack.field_190927_a);
        }
    }

    @Override
    public void setPos(int dimensionID, int x, int y, int z) {
        this.dimension = dimensionID;
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public void setType(int type) {
        if (type < 0 || type > 2) {
            throw new CustomNPCsException("Unknown location type: " + type, new Object[0]);
        }
        this.type = type;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Id", this.id);
        compound.func_74780_a("PosX", (double)this.pos.func_177958_n());
        compound.func_74780_a("PosY", (double)this.pos.func_177956_o());
        compound.func_74780_a("PosZ", (double)this.pos.func_177952_p());
        compound.func_74768_a("Type", this.type);
        compound.func_74768_a("Dimension", this.dimension);
        compound.func_74778_a("Name", this.name);
        if (this.npc != null) {
            compound.func_186854_a("NpcUUID", this.npc);
        }
        compound.func_74772_a("Cost", this.money);
        compound.func_74782_a("CostInv", (NBTBase)this.inventory.save());
        compound.func_74776_a("PlayerYaw", this.yaw);
        compound.func_74776_a("PlayerPitch", this.pitch);
        return compound;
    }
}

